#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timers 4 and 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  ReadTimer45                                    *
*    Description:    This routine reads the 32-bit value from       *
*                    Timer4 and Timer5.                             *
*    Parameters:     None                                           *
*    Return Value:   unsigned long: Timer4 and Timer5  32-bit value *
********************************************************************/

unsigned long ReadTimer45(void)
{
    unsigned long timer;
    timer = TMR4;                        /* Copy Timer4 into timer low 16bit */
    timer |= (unsigned long)TMR5HLD<<16; /* shift  16 time as TMR 5 
                                            contains MSB , TMR4 LSB */ 
    return (timer);
}

#endif 
